# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if getattr(globals().get("__spec__"), "parent", None) or globals().get("__package__") or "." in __name__:
    from . import _advisory
else:
    import _advisory

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)


class SwigPyIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")

    def __init__(self, *args, **kwargs):
        raise AttributeError("No constructor defined - class is abstract")
    __repr__ = _swig_repr
    __swig_destroy__ = _advisory.delete_SwigPyIterator

    def value(self):
        return _advisory.SwigPyIterator_value(self)

    def incr(self, n=1):
        return _advisory.SwigPyIterator_incr(self, n)

    def decr(self, n=1):
        return _advisory.SwigPyIterator_decr(self, n)

    def distance(self, x):
        return _advisory.SwigPyIterator_distance(self, x)

    def equal(self, x):
        return _advisory.SwigPyIterator_equal(self, x)

    def copy(self):
        return _advisory.SwigPyIterator_copy(self)

    def next(self):
        return _advisory.SwigPyIterator_next(self)

    def __next__(self):
        return _advisory.SwigPyIterator___next__(self)

    def previous(self):
        return _advisory.SwigPyIterator_previous(self)

    def advance(self, n):
        return _advisory.SwigPyIterator_advance(self, n)

    def __eq__(self, x):
        return _advisory.SwigPyIterator___eq__(self, x)

    def __ne__(self, x):
        return _advisory.SwigPyIterator___ne__(self, x)

    def __iadd__(self, n):
        return _advisory.SwigPyIterator___iadd__(self, n)

    def __isub__(self, n):
        return _advisory.SwigPyIterator___isub__(self, n)

    def __add__(self, n):
        return _advisory.SwigPyIterator___add__(self, n)

    def __sub__(self, *args):
        return _advisory.SwigPyIterator___sub__(self, *args)
    def __iter__(self):
        return self

# Register SwigPyIterator in _advisory:
_advisory.SwigPyIterator_swigregister(SwigPyIterator)
from . import common
from . import exception
class AdvisoryId(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _advisory.AdvisoryId_swiginit(self, _advisory.new_AdvisoryId(*args))

    def __eq__(self, other):
        return _advisory.AdvisoryId___eq__(self, other)

    def __ne__(self, other):
        return _advisory.AdvisoryId___ne__(self, other)
    id = property(_advisory.AdvisoryId_id_get, _advisory.AdvisoryId_id_set)
    __swig_destroy__ = _advisory.delete_AdvisoryId

# Register AdvisoryId in _advisory:
_advisory.AdvisoryId_swigregister(AdvisoryId)
class Advisory(object):
    r"""An advisory, represents advisory used to track security updates"""

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _advisory.Advisory_swiginit(self, _advisory.new_Advisory(*args))

    def __eq__(self, other):
        return _advisory.Advisory___eq__(self, other)

    def __ne__(self, other):
        return _advisory.Advisory___ne__(self, other)
    __swig_destroy__ = _advisory.delete_Advisory

    def get_name(self):
        r"""
        Get name of this advisory.

        :rtype: string
        :return: Name of this advisory as std::string.
        """
        return _advisory.Advisory_get_name(self)

    def get_severity(self):
        r"""
        Get severity of this advisory.

        :rtype: string
        :return: Severity of this advisory as std::string.
        """
        return _advisory.Advisory_get_severity(self)

    def get_type(self):
        r"""
        Get type of this advisory.
        Possible types are: "security", "bugfix", "enhancement", "newpackage".

        :rtype: string
        :return: type of this advisory as std::string.
        """
        return _advisory.Advisory_get_type(self)

    def get_buildtime(self):
        r"""
        Get buildtime of this advisory. Libsolv combines issued and updated dates
        into buildtime by always using the newer one.

        :rtype: int
        :return: buildtime of this advisory.
        """
        return _advisory.Advisory_get_buildtime(self)

    def get_vendor(self):
        r"""
        Get vendor of this advisory.

        :rtype: string
        :return: Vendor of this advisory as std::string.
        """
        return _advisory.Advisory_get_vendor(self)

    def get_description(self):
        r"""
        Get description of this advisory.

        :rtype: string
        :return: Description of this advisory as std::string.
        """
        return _advisory.Advisory_get_description(self)

    def get_title(self):
        r"""
        Get title of this advisory.

        :rtype: string
        :return: Title of this advisory as std::string.
        """
        return _advisory.Advisory_get_title(self)

    def get_status(self):
        r"""
        Get status of this advisory.

        :rtype: string
        :return: Status of this advisory as std::string.
        """
        return _advisory.Advisory_get_status(self)

    def get_rights(self):
        r"""
        Get rights of this advisory.

        :rtype: string
        :return: Rights of this advisory as std::string.
        """
        return _advisory.Advisory_get_rights(self)

    def get_message(self):
        r"""
        Get message of this advisory.

        :rtype: string
        :return: Message of this advisory as std::string.
        """
        return _advisory.Advisory_get_message(self)

    def get_id(self):
        r"""
        Get AdvisoryId.

        :rtype: :py:class:`AdvisoryId`
        :return: AdvisoryId of this advisory.
        """
        return _advisory.Advisory_get_id(self)

    def get_references(self, *args):
        r"""
        Get all references of specified type from this advisory.
        Possible refenrece types are: "bugzilla", "cve", "vendor".

        :type types: std::vector< std::string,std::allocator< std::string > >, optional
        :param types:     What types of references to get. If not specified gets all types.
        :rtype: std::vector< libdnf5::advisory::AdvisoryReference,std::allocator< libdnf5::advisory::AdvisoryReference > >
        :return: Vector of AdvisoryReference objects.
        """
        return _advisory.Advisory_get_references(self, *args)

    def get_collections(self):
        r"""
        Get all collections from this advisory.

        :rtype: std::vector< libdnf5::advisory::AdvisoryCollection,std::allocator< libdnf5::advisory::AdvisoryCollection > >
        :return: Vector of AdvisoryCollection objects.
        """
        return _advisory.Advisory_get_collections(self)

    def is_applicable(self):
        r"""
        Check whether at least one collection from this advisory is applicable.

        :rtype: boolean
        :return: True if applicable, False otherwise.
        """
        return _advisory.Advisory_is_applicable(self)

# Register Advisory in _advisory:
_advisory.Advisory_swigregister(Advisory)
class AdvisoryPackage(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _advisory.AdvisoryPackage_swiginit(self, _advisory.new_AdvisoryPackage(*args))
    __swig_destroy__ = _advisory.delete_AdvisoryPackage

    def get_name(self):
        r"""
        Get name of this AdvisoryPackage.

        :rtype: string
        :return: Name of this AdvisoryPackage as std::string.
        """
        return _advisory.AdvisoryPackage_get_name(self)

    def get_epoch(self):
        r"""
        Get epoch of this AdvisoryPackage.

        :rtype: string
        :return: Epoch of this AdvisoryPackage as std::string.
        """
        return _advisory.AdvisoryPackage_get_epoch(self)

    def get_version(self):
        r"""
        Get version of this AdvisoryPackage.

        :rtype: string
        :return: Version of this AdvisoryPackage as std::string.
        """
        return _advisory.AdvisoryPackage_get_version(self)

    def get_release(self):
        r"""
        Get release version of this AdvisoryPackage.

        :rtype: string
        :return: Release of this AdvisoryPackage as std::string.
        """
        return _advisory.AdvisoryPackage_get_release(self)

    def get_evr(self):
        r"""
        Get evr of this AdvisoryPackage.

        :rtype: string
        :return: Evr of this AdvisoryPackage as std::string.
        """
        return _advisory.AdvisoryPackage_get_evr(self)

    def get_arch(self):
        r"""
        Get arch of this AdvisoryPackage.

        :rtype: string
        :return: Arch of this AdvisoryPackage as std::string.
        """
        return _advisory.AdvisoryPackage_get_arch(self)

    def get_nevra(self):
        r"""
        Get NEVRA of this AdvisoryPackage.

        :rtype: string
        :return: NEVRA of this AdvisoryPackage as std::string.
        """
        return _advisory.AdvisoryPackage_get_nevra(self)

    def get_advisory_id(self):
        r"""
        Get AdvisoryId of Advisory this AdvisoryPackage belongs to.

        :rtype: :py:class:`AdvisoryId`
        :return: AdvisoryId of this AdvisoryPackage.
        """
        return _advisory.AdvisoryPackage_get_advisory_id(self)

    def get_reboot_suggested(self):
        r"""
        Get bool value whether reboot is suggested

        :rtype: boolean
        :return: Reboot suggestion of this advisory package as bool
        """
        return _advisory.AdvisoryPackage_get_reboot_suggested(self)

    def get_restart_suggested(self):
        r"""
        Get bool value whether restart is suggested

        :rtype: boolean
        :return: Restart suggestion of this advisory package as bool
        """
        return _advisory.AdvisoryPackage_get_restart_suggested(self)

    def get_relogin_suggested(self):
        r"""
        Get bool value whether relogin is suggested

        :rtype: boolean
        :return: Relogin suggestion of this advisory package as bool
        """
        return _advisory.AdvisoryPackage_get_relogin_suggested(self)

    def get_advisory(self):
        r"""
        Get Advisory this AdvisoryPackage belongs to.

        :rtype: :py:class:`Advisory`
        :return: newly construted Advisory object of this AdvisoryPackage.
        """
        return _advisory.AdvisoryPackage_get_advisory(self)

    def get_advisory_collection(self):
        r"""
        Get AdvisoryCollection this AdvisoryPackage belongs to.

        :rtype: :py:class:`AdvisoryCollection`
        :return: newly construted AdvisoryCollection object of this AdvisoryPackage.
        """
        return _advisory.AdvisoryPackage_get_advisory_collection(self)

# Register AdvisoryPackage in _advisory:
_advisory.AdvisoryPackage_swigregister(AdvisoryPackage)
class AdvisorySet(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _advisory.AdvisorySet_swiginit(self, _advisory.new_AdvisorySet(*args))
    __swig_destroy__ = _advisory.delete_AdvisorySet

    def begin(self):
        return _advisory.AdvisorySet_begin(self)

    def end(self):
        return _advisory.AdvisorySet_end(self)

    def __ior__(self, other):
        return _advisory.AdvisorySet___ior__(self, other)

    def __isub__(self, other):
        return _advisory.AdvisorySet___isub__(self, other)

    def __iand__(self, other):
        return _advisory.AdvisorySet___iand__(self, other)

    def update(self, other):
        r"""
        Set union: elements that are in the current set or in the `other` set.

        :type other: :py:class:`AdvisorySet`
        :param other: The set to unify with.
        :raises: UsedDifferentSack When the sets entering the operation do not share the same AdvisorySack.
        Since: 5.0
        """
        return _advisory.AdvisorySet_update(self, other)

    def intersection(self, other):
        r"""
        Set intersection: elements in the current set that are also in the `other` set.

        :type other: :py:class:`AdvisorySet`
        :param other: The set to intersect with.
        :raises: UsedDifferentSack When the sets entering the operation do not share the same AdvisorySack.
        Since: 5.0
        """
        return _advisory.AdvisorySet_intersection(self, other)

    def difference(self, other):
        r"""
        Set difference: elements in the current set that are not in the `other` set.

        :type other: :py:class:`AdvisorySet`
        :param other: The set to check for differences in.
        :raises: UsedDifferentSack When the sets entering the operation do not share the same AdvisorySack.
        Since: 5.0
        """
        return _advisory.AdvisorySet_difference(self, other)

    def clear(self):
        r"""
        Remove all advisories from the set.

        Since: 5.0
        """
        return _advisory.AdvisorySet_clear(self)

    def empty(self):
        r"""
        :rtype: boolean
        :return: `true` if the set is empty, `false` otherwise.
        Since: 5.0
        """
        return _advisory.AdvisorySet_empty(self)

    def add(self, adv):
        r"""
        Add `adv` to the set.

        :type adv: :py:class:`Advisory`
        :param adv: Advisory to be added to the set.
        Since: 5.0
        """
        return _advisory.AdvisorySet_add(self, adv)

    def contains(self, adv):
        r"""
        :rtype: boolean
        :return: `true` if an advisory is in the set, `false` otherwise.
        :type adv: :py:class:`Advisory`
        :param adv: Advisory that is tested for presence.
        Since: 5.0
        """
        return _advisory.AdvisorySet_contains(self, adv)

    def remove(self, adv):
        r"""
        Remove `adv` from the set.

        :type adv: :py:class:`Advisory`
        :param adv: Advisory to be removed from the set.
        Since: 5.0
        """
        return _advisory.AdvisorySet_remove(self, adv)

    def get_base(self):
        return _advisory.AdvisorySet_get_base(self)

    def size(self):
        r"""
        :rtype: int
        :return: Number of elements in the set.
        """
        return _advisory.AdvisorySet_size(self)

    def swap(self, other):
        return _advisory.AdvisorySet_swap(self, other)

    def get_advisory_packages_sorted_by_name_arch_evr(self, only_applicable=False):
        r"""
        Gather AdvisoryPackages for each Advisory in the set.
        The AdvisoryPackages are sorted by libsolv `id`s of name, arch and evr.
        This is a different sorting than sorting by the strings of AdvisoryPackages names, architectures and evrs.

        :type only_applicable: boolean, optional
        :param only_applicable: Whether to return only AdvisoryPackages from applicable AdvisoryCollections.
        Since: 5.0
        """
        return _advisory.AdvisorySet_get_advisory_packages_sorted_by_name_arch_evr(self, only_applicable)

    def get_advisory_packages_sorted_by_name_arch_evr_string(self, only_applicable=False):
        r"""
        Gather AdvisoryPackages for each Advisory in the set.
        The AdvisoryPackages are sorted by name, arch and evr. name and arch are
        compared as strings, evr uses libdnf5::rpm::evrcmp() function.

        :type only_applicable: boolean, optional
        :param only_applicable: Whether to return only AdvisoryPackages from applicable AdvisoryCollections.
        """
        return _advisory.AdvisorySet_get_advisory_packages_sorted_by_name_arch_evr_string(self, only_applicable)

# Register AdvisorySet in _advisory:
_advisory.AdvisorySet_swigregister(AdvisorySet)
class AdvisorySetIterator(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, other):
        _advisory.AdvisorySetIterator_swiginit(self, _advisory.new_AdvisorySetIterator(other))
    __swig_destroy__ = _advisory.delete_AdvisorySetIterator

    def value(self):
        return _advisory.AdvisorySetIterator_value(self)

    def next(self):
        return _advisory.AdvisorySetIterator_next(self)

    def __eq__(self, other):
        return _advisory.AdvisorySetIterator___eq__(self, other)

    def __ne__(self, other):
        return _advisory.AdvisorySetIterator___ne__(self, other)

    def begin(self, *args):
        return _advisory.AdvisorySetIterator_begin(self, *args)

    def end(self, *args):
        return _advisory.AdvisorySetIterator_end(self, *args)

# Register AdvisorySetIterator in _advisory:
_advisory.AdvisorySetIterator_swigregister(AdvisorySetIterator)
class AdvisoryModule(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _advisory.AdvisoryModule_swiginit(self, _advisory.new_AdvisoryModule(*args))
    __swig_destroy__ = _advisory.delete_AdvisoryModule

    def get_name(self):
        r"""
        Get name of this AdvisoryModule.

        :rtype: string
        :return: Name of this AdvisoryModule as std::string.
        """
        return _advisory.AdvisoryModule_get_name(self)

    def get_stream(self):
        r"""
        Get stream of this AdvisoryModule.

        :rtype: string
        :return: Stream of this AdvisoryModule as std::string.
        """
        return _advisory.AdvisoryModule_get_stream(self)

    def get_version(self):
        r"""
        Get version of this AdvisoryModule.

        :rtype: string
        :return: Version of this AdvisoryModule as std::string.
        """
        return _advisory.AdvisoryModule_get_version(self)

    def get_context(self):
        r"""
        Get context of this AdvisoryModule.

        :rtype: string
        :return: Context of this AdvisoryModule as std::string.
        """
        return _advisory.AdvisoryModule_get_context(self)

    def get_arch(self):
        r"""
        Get arch of this AdvisoryModule.

        :rtype: string
        :return: Arch of this AdvisoryModule as std::string.
        """
        return _advisory.AdvisoryModule_get_arch(self)

    def get_nsvca(self):
        r"""
        Get NSVCA of this AdvisoryModule.

        :rtype: string
        :return: NSVCA of this AdvisoryModule as std::string.
        """
        return _advisory.AdvisoryModule_get_nsvca(self)

    def get_advisory_id(self):
        r"""
        Get AdvisoryId of Advisory this AdvisoryModule belongs to.

        :rtype: :py:class:`AdvisoryId`
        :return: AdvisoryId of this AdvisoryModule.
        """
        return _advisory.AdvisoryModule_get_advisory_id(self)

    def get_advisory(self):
        r"""
        Get Advisory this AdvisoryModule belongs to.

        :rtype: :py:class:`Advisory`
        :return: newly construted Advisory object of this AdvisoryModule.
        """
        return _advisory.AdvisoryModule_get_advisory(self)

    def get_advisory_collection(self):
        r"""
        Get AdvisoryCollection this AdvisoryModule belongs to.

        :rtype: :py:class:`AdvisoryCollection`
        :return: newly construted AdvisoryCollection object of this AdvisoryModule.
        """
        return _advisory.AdvisoryModule_get_advisory_collection(self)

# Register AdvisoryModule in _advisory:
_advisory.AdvisoryModule_swigregister(AdvisoryModule)
class AdvisoryCollection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _advisory.AdvisoryCollection_swiginit(self, _advisory.new_AdvisoryCollection(*args))
    __swig_destroy__ = _advisory.delete_AdvisoryCollection

    def is_applicable(self):
        r"""
        Whether this AdvisoryCollection is applicable. True when at least one AdvisoryModule in this
        AdvisoryCollection is active on the system, False otherwise.
        """
        return _advisory.AdvisoryCollection_is_applicable(self)

    def get_advisory_id(self):
        r"""
        Get AdvisoryId of Advisory this AdvisoryCollection belongs to.

        :rtype: :py:class:`AdvisoryId`
        :return: AdvisoryId of this AdvisoryCollection.
        """
        return _advisory.AdvisoryCollection_get_advisory_id(self)

    def get_packages(self):
        r"""
        Get all AdvisoryPackages stored in this AdvisoryCollection

        :rtype: std::vector< libdnf5::advisory::AdvisoryPackage,std::allocator< libdnf5::advisory::AdvisoryPackage > >
        :return: std::vector of AdvisorPackages used as output.
        """
        return _advisory.AdvisoryCollection_get_packages(self)

    def get_modules(self):
        r"""
        Get all AdvisoryModules stored in this AdvisoryCollection

        :rtype: std::vector< libdnf5::advisory::AdvisoryModule,std::allocator< libdnf5::advisory::AdvisoryModule > >
        :return: std::vector of AdvisorModules.
        """
        return _advisory.AdvisoryCollection_get_modules(self)

    def get_advisory(self):
        r"""
        Get Advisory this AdvisoryCollection belongs to.

        :rtype: :py:class:`Advisory`
        :return: newly construted Advisory object of this AdvisoryCollection.
        """
        return _advisory.AdvisoryCollection_get_advisory(self)

# Register AdvisoryCollection in _advisory:
_advisory.AdvisoryCollection_swigregister(AdvisoryCollection)
class AdvisoryQuery(AdvisorySet):
    r"""
    AdvisoryQuery is the only way how to access advisories.
    It is constructed using Base and filled with advisories from enabled repositories in its RepoSack.
    """

    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        r"""
        *Overload 1:*
        Create a new AdvisoryQuery instance.

        :type base: libdnf5::BaseWeakPtr
        :param base:     A weak pointer to Base

        |

        *Overload 2:*
        Create a new AdvisoryQuery instance.

        :type base: libdnf5::Base
        :param base:     Reference to Base
        """
        _advisory.AdvisoryQuery_swiginit(self, _advisory.new_AdvisoryQuery(*args))
    __swig_destroy__ = _advisory.delete_AdvisoryQuery

    def filter_name(self, *args):
        r"""
        Filter Advisories by name.

        :type pattern: string
        :param pattern:      Pattern used when matching against advisory names.
        :type cmp_type: int, optional
        :param cmp_type:     What comparator to use with pattern, allows: EQ, GLOB, IGLOB.
        """
        return _advisory.AdvisoryQuery_filter_name(self, *args)

    def filter_type(self, *args):
        r"""
        Filter Advisories by type.

        :type type: string
        :param type:         Possible types are: "security", "bugfix", "enhancement", "newpackage".
        :type cmp_type: int, optional
        :param cmp_type:     What comparator to use with type, allows: IEXACT (default), EQ.
        """
        return _advisory.AdvisoryQuery_filter_type(self, *args)

    def filter_reference(self, *args):
        r"""
        Filter Advisories by reference.

        :type pattern: string
        :param pattern:      Pattern to match with reference id.
        :type cmp_type: int, optional
        :param cmp_type:     What comparator to use with pattern, allows: EQ, IEXACT, GLOB, IGLOB, CONTAINS, ICONTAINS.
        :param type:         Possible reference types are: "bugzilla", "cve", "vendor". If none is specified it matches all.
        """
        return _advisory.AdvisoryQuery_filter_reference(self, *args)

    def filter_severity(self, *args):
        r"""
        Filter Advisories by severity.

        :type severity: string
        :param severity:     Possible severities are: "critical", "important", "moderate", "low", "none".
        :type cmp_type: int, optional
        :param cmp_type:     What comparator to use with severity, allows: IEXACT (default), EQ.
        """
        return _advisory.AdvisoryQuery_filter_severity(self, *args)

    def filter_packages(self, *args):
        r"""
        *Overload 1:*
        Filter out advisories that don't contain at least one AdvisoryPackage that has a counterpart Package in package_set
        such that they have matching name and architecture and also their epoch-version-release complies to cmp_type.

        :type package_set: libdnf5::rpm::PackageSet
        :param package_set:  libdnf5::rpm::PackageSet used when filtering.
        :type cmp_type: int, optional
        :param cmp_type:     Condition to fulfill when comparing epoch-version-release of packages.

        |

        *Overload 2:*
        Filter out advisories that don't contain at least one AdvisoryPackage that has a counterpart Package in nevras
        such that they have matching name and architecture and also their epoch-version-release complies to cmp_type.

        :type nevras: std::vector< libdnf5::rpm::Nevra,std::allocator< libdnf5::rpm::Nevra > >
        :param nevras:       std::vector<libdnf5::rpm::Nevra> used when filtering.
        :type cmp_type: int, optional
        :param cmp_type:     Condition to fulfill when comparing epoch-version-release of packages.

        |

        *Overload 3:*
        Filter out advisories that don't contain at least one AdvisoryPackage that has a counterpart Package in nevras
        such that they have matching name and architecture and also their epoch-version-release complies to cmp_type.

        :type nevras: std::vector< libdnf5::rpm::Nevra,std::allocator< libdnf5::rpm::Nevra > >
        :param nevras:       std::vector<libdnf5::rpm::Nevra> used when filtering.
        :param cmp_type:     Condition to fulfill when comparing epoch-version-release of packages.
        """
        return _advisory.AdvisoryQuery_filter_packages(self, *args)

    def get_advisory_packages_sorted(self, *args):
        r"""
        Get std::vector of AdvisoryPackages present in advisories from query.
        Each AdvisoryPackage is returned only if it has a counterpart Package in package_set such that they have matching
        name and architecture and also their epoch-version-release complies to cmp_type.
        AdvisoryPackages are sorted in the std::vector by Name, Arch and EVR.

        :type package_set: libdnf5::rpm::PackageSet
        :param package_set:  libdnf5::rpm::PackageSet used when filtering.
        :type cmp_type: int, optional
        :param cmp_type:     Condition to fulfill when comparing epoch-version-release of packages.
        :rtype: std::vector< libdnf5::advisory::AdvisoryPackage,std::allocator< libdnf5::advisory::AdvisoryPackage > >
        :return: std::vector of AdvisoryPackages
        """
        return _advisory.AdvisoryQuery_get_advisory_packages_sorted(self, *args)

# Register AdvisoryQuery in _advisory:
_advisory.AdvisoryQuery_swigregister(AdvisoryQuery)
class AdvisoryReference(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def __init__(self, *args):
        _advisory.AdvisoryReference_swiginit(self, _advisory.new_AdvisoryReference(*args))
    __swig_destroy__ = _advisory.delete_AdvisoryReference

    def get_id(self):
        r"""
        Get id of this advisory reference, this id is like a name of this reference
        (it is not libsolv id).

        :rtype: string
        :return: id of this reference as std::string.
        """
        return _advisory.AdvisoryReference_get_id(self)

    def get_type(self):
        r"""
        Get type of this reference.
        Possible reference types are: "bugzilla", "cve", "vendor".

        :rtype: string
        :return: type of this reference as std::string.
        """
        return _advisory.AdvisoryReference_get_type(self)

    def get_type_cstring(self):
        r"""
        Get type of this reference.

        :rtype: string
        :return: Type of this reference as const char* !! (temporal value)
        """
        return _advisory.AdvisoryReference_get_type_cstring(self)

    def get_title(self):
        r"""
        Get title of this reference.

        :rtype: string
        :return: Title of this reference.
        """
        return _advisory.AdvisoryReference_get_title(self)

    def get_url(self):
        r"""
        Get url of this reference.

        :rtype: string
        :return: Url of this reference.
        """
        return _advisory.AdvisoryReference_get_url(self)

# Register AdvisoryReference in _advisory:
_advisory.AdvisoryReference_swigregister(AdvisoryReference)
class VectorAdvisoryModule(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _advisory.VectorAdvisoryModule_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _advisory.VectorAdvisoryModule___nonzero__(self)

    def __bool__(self):
        return _advisory.VectorAdvisoryModule___bool__(self)

    def __len__(self):
        return _advisory.VectorAdvisoryModule___len__(self)

    def __getslice__(self, i, j):
        return _advisory.VectorAdvisoryModule___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _advisory.VectorAdvisoryModule___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _advisory.VectorAdvisoryModule___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _advisory.VectorAdvisoryModule___delitem__(self, *args)

    def __getitem__(self, *args):
        return _advisory.VectorAdvisoryModule___getitem__(self, *args)

    def __setitem__(self, *args):
        return _advisory.VectorAdvisoryModule___setitem__(self, *args)

    def pop(self):
        return _advisory.VectorAdvisoryModule_pop(self)

    def append(self, x):
        return _advisory.VectorAdvisoryModule_append(self, x)

    def empty(self):
        return _advisory.VectorAdvisoryModule_empty(self)

    def size(self):
        return _advisory.VectorAdvisoryModule_size(self)

    def swap(self, v):
        return _advisory.VectorAdvisoryModule_swap(self, v)

    def begin(self):
        return _advisory.VectorAdvisoryModule_begin(self)

    def end(self):
        return _advisory.VectorAdvisoryModule_end(self)

    def rbegin(self):
        return _advisory.VectorAdvisoryModule_rbegin(self)

    def rend(self):
        return _advisory.VectorAdvisoryModule_rend(self)

    def clear(self):
        return _advisory.VectorAdvisoryModule_clear(self)

    def get_allocator(self):
        return _advisory.VectorAdvisoryModule_get_allocator(self)

    def pop_back(self):
        return _advisory.VectorAdvisoryModule_pop_back(self)

    def erase(self, *args):
        return _advisory.VectorAdvisoryModule_erase(self, *args)

    def __init__(self, *args):
        _advisory.VectorAdvisoryModule_swiginit(self, _advisory.new_VectorAdvisoryModule(*args))

    def push_back(self, x):
        return _advisory.VectorAdvisoryModule_push_back(self, x)

    def front(self):
        return _advisory.VectorAdvisoryModule_front(self)

    def back(self):
        return _advisory.VectorAdvisoryModule_back(self)

    def assign(self, n, x):
        return _advisory.VectorAdvisoryModule_assign(self, n, x)

    def insert(self, *args):
        return _advisory.VectorAdvisoryModule_insert(self, *args)

    def reserve(self, n):
        return _advisory.VectorAdvisoryModule_reserve(self, n)

    def capacity(self):
        return _advisory.VectorAdvisoryModule_capacity(self)
    __swig_destroy__ = _advisory.delete_VectorAdvisoryModule

# Register VectorAdvisoryModule in _advisory:
_advisory.VectorAdvisoryModule_swigregister(VectorAdvisoryModule)
class VectorAdvisoryCollection(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _advisory.VectorAdvisoryCollection_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _advisory.VectorAdvisoryCollection___nonzero__(self)

    def __bool__(self):
        return _advisory.VectorAdvisoryCollection___bool__(self)

    def __len__(self):
        return _advisory.VectorAdvisoryCollection___len__(self)

    def __getslice__(self, i, j):
        return _advisory.VectorAdvisoryCollection___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _advisory.VectorAdvisoryCollection___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _advisory.VectorAdvisoryCollection___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _advisory.VectorAdvisoryCollection___delitem__(self, *args)

    def __getitem__(self, *args):
        return _advisory.VectorAdvisoryCollection___getitem__(self, *args)

    def __setitem__(self, *args):
        return _advisory.VectorAdvisoryCollection___setitem__(self, *args)

    def pop(self):
        return _advisory.VectorAdvisoryCollection_pop(self)

    def append(self, x):
        return _advisory.VectorAdvisoryCollection_append(self, x)

    def empty(self):
        return _advisory.VectorAdvisoryCollection_empty(self)

    def size(self):
        return _advisory.VectorAdvisoryCollection_size(self)

    def swap(self, v):
        return _advisory.VectorAdvisoryCollection_swap(self, v)

    def begin(self):
        return _advisory.VectorAdvisoryCollection_begin(self)

    def end(self):
        return _advisory.VectorAdvisoryCollection_end(self)

    def rbegin(self):
        return _advisory.VectorAdvisoryCollection_rbegin(self)

    def rend(self):
        return _advisory.VectorAdvisoryCollection_rend(self)

    def clear(self):
        return _advisory.VectorAdvisoryCollection_clear(self)

    def get_allocator(self):
        return _advisory.VectorAdvisoryCollection_get_allocator(self)

    def pop_back(self):
        return _advisory.VectorAdvisoryCollection_pop_back(self)

    def erase(self, *args):
        return _advisory.VectorAdvisoryCollection_erase(self, *args)

    def __init__(self, *args):
        _advisory.VectorAdvisoryCollection_swiginit(self, _advisory.new_VectorAdvisoryCollection(*args))

    def push_back(self, x):
        return _advisory.VectorAdvisoryCollection_push_back(self, x)

    def front(self):
        return _advisory.VectorAdvisoryCollection_front(self)

    def back(self):
        return _advisory.VectorAdvisoryCollection_back(self)

    def assign(self, n, x):
        return _advisory.VectorAdvisoryCollection_assign(self, n, x)

    def insert(self, *args):
        return _advisory.VectorAdvisoryCollection_insert(self, *args)

    def reserve(self, n):
        return _advisory.VectorAdvisoryCollection_reserve(self, n)

    def capacity(self):
        return _advisory.VectorAdvisoryCollection_capacity(self)
    __swig_destroy__ = _advisory.delete_VectorAdvisoryCollection

# Register VectorAdvisoryCollection in _advisory:
_advisory.VectorAdvisoryCollection_swigregister(VectorAdvisoryCollection)
class VectorAdvisoryPackage(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _advisory.VectorAdvisoryPackage_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _advisory.VectorAdvisoryPackage___nonzero__(self)

    def __bool__(self):
        return _advisory.VectorAdvisoryPackage___bool__(self)

    def __len__(self):
        return _advisory.VectorAdvisoryPackage___len__(self)

    def __getslice__(self, i, j):
        return _advisory.VectorAdvisoryPackage___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _advisory.VectorAdvisoryPackage___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _advisory.VectorAdvisoryPackage___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _advisory.VectorAdvisoryPackage___delitem__(self, *args)

    def __getitem__(self, *args):
        return _advisory.VectorAdvisoryPackage___getitem__(self, *args)

    def __setitem__(self, *args):
        return _advisory.VectorAdvisoryPackage___setitem__(self, *args)

    def pop(self):
        return _advisory.VectorAdvisoryPackage_pop(self)

    def append(self, x):
        return _advisory.VectorAdvisoryPackage_append(self, x)

    def empty(self):
        return _advisory.VectorAdvisoryPackage_empty(self)

    def size(self):
        return _advisory.VectorAdvisoryPackage_size(self)

    def swap(self, v):
        return _advisory.VectorAdvisoryPackage_swap(self, v)

    def begin(self):
        return _advisory.VectorAdvisoryPackage_begin(self)

    def end(self):
        return _advisory.VectorAdvisoryPackage_end(self)

    def rbegin(self):
        return _advisory.VectorAdvisoryPackage_rbegin(self)

    def rend(self):
        return _advisory.VectorAdvisoryPackage_rend(self)

    def clear(self):
        return _advisory.VectorAdvisoryPackage_clear(self)

    def get_allocator(self):
        return _advisory.VectorAdvisoryPackage_get_allocator(self)

    def pop_back(self):
        return _advisory.VectorAdvisoryPackage_pop_back(self)

    def erase(self, *args):
        return _advisory.VectorAdvisoryPackage_erase(self, *args)

    def __init__(self, *args):
        _advisory.VectorAdvisoryPackage_swiginit(self, _advisory.new_VectorAdvisoryPackage(*args))

    def push_back(self, x):
        return _advisory.VectorAdvisoryPackage_push_back(self, x)

    def front(self):
        return _advisory.VectorAdvisoryPackage_front(self)

    def back(self):
        return _advisory.VectorAdvisoryPackage_back(self)

    def assign(self, n, x):
        return _advisory.VectorAdvisoryPackage_assign(self, n, x)

    def insert(self, *args):
        return _advisory.VectorAdvisoryPackage_insert(self, *args)

    def reserve(self, n):
        return _advisory.VectorAdvisoryPackage_reserve(self, n)

    def capacity(self):
        return _advisory.VectorAdvisoryPackage_capacity(self)
    __swig_destroy__ = _advisory.delete_VectorAdvisoryPackage

# Register VectorAdvisoryPackage in _advisory:
_advisory.VectorAdvisoryPackage_swigregister(VectorAdvisoryPackage)
class VectorAdvisoryReference(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr

    def iterator(self):
        return _advisory.VectorAdvisoryReference_iterator(self)
    def __iter__(self):
        return self.iterator()

    def __nonzero__(self):
        return _advisory.VectorAdvisoryReference___nonzero__(self)

    def __bool__(self):
        return _advisory.VectorAdvisoryReference___bool__(self)

    def __len__(self):
        return _advisory.VectorAdvisoryReference___len__(self)

    def __getslice__(self, i, j):
        return _advisory.VectorAdvisoryReference___getslice__(self, i, j)

    def __setslice__(self, *args):
        return _advisory.VectorAdvisoryReference___setslice__(self, *args)

    def __delslice__(self, i, j):
        return _advisory.VectorAdvisoryReference___delslice__(self, i, j)

    def __delitem__(self, *args):
        return _advisory.VectorAdvisoryReference___delitem__(self, *args)

    def __getitem__(self, *args):
        return _advisory.VectorAdvisoryReference___getitem__(self, *args)

    def __setitem__(self, *args):
        return _advisory.VectorAdvisoryReference___setitem__(self, *args)

    def pop(self):
        return _advisory.VectorAdvisoryReference_pop(self)

    def append(self, x):
        return _advisory.VectorAdvisoryReference_append(self, x)

    def empty(self):
        return _advisory.VectorAdvisoryReference_empty(self)

    def size(self):
        return _advisory.VectorAdvisoryReference_size(self)

    def swap(self, v):
        return _advisory.VectorAdvisoryReference_swap(self, v)

    def begin(self):
        return _advisory.VectorAdvisoryReference_begin(self)

    def end(self):
        return _advisory.VectorAdvisoryReference_end(self)

    def rbegin(self):
        return _advisory.VectorAdvisoryReference_rbegin(self)

    def rend(self):
        return _advisory.VectorAdvisoryReference_rend(self)

    def clear(self):
        return _advisory.VectorAdvisoryReference_clear(self)

    def get_allocator(self):
        return _advisory.VectorAdvisoryReference_get_allocator(self)

    def pop_back(self):
        return _advisory.VectorAdvisoryReference_pop_back(self)

    def erase(self, *args):
        return _advisory.VectorAdvisoryReference_erase(self, *args)

    def __init__(self, *args):
        _advisory.VectorAdvisoryReference_swiginit(self, _advisory.new_VectorAdvisoryReference(*args))

    def push_back(self, x):
        return _advisory.VectorAdvisoryReference_push_back(self, x)

    def front(self):
        return _advisory.VectorAdvisoryReference_front(self)

    def back(self):
        return _advisory.VectorAdvisoryReference_back(self)

    def assign(self, n, x):
        return _advisory.VectorAdvisoryReference_assign(self, n, x)

    def insert(self, *args):
        return _advisory.VectorAdvisoryReference_insert(self, *args)

    def reserve(self, n):
        return _advisory.VectorAdvisoryReference_reserve(self, n)

    def capacity(self):
        return _advisory.VectorAdvisoryReference_capacity(self)
    __swig_destroy__ = _advisory.delete_VectorAdvisoryReference

# Register VectorAdvisoryReference in _advisory:
_advisory.VectorAdvisoryReference_swigregister(VectorAdvisoryReference)

def AdvisorySet__iter__(self):
    return common.Iterator(self, self.begin(), self.end())
AdvisorySet.__iter__ = AdvisorySet__iter__
del AdvisorySet__iter__


